/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketTileEntityRoadCollisionUpdate
extends APacketEntity<TileEntityRoad> {
    private final List<Point3D> collisionBlockOffsets;
    private final List<Point3D> collidingBlockOffsets;

    public PacketTileEntityRoadCollisionUpdate(TileEntityRoad road) {
        super(road);
        this.collisionBlockOffsets = road.collisionBlockOffsets;
        this.collidingBlockOffsets = road.collidingBlockOffsets;
    }

    public PacketTileEntityRoadCollisionUpdate(ByteBuf buf) {
        super(buf);
        this.collisionBlockOffsets = new ArrayList<Point3D>();
        int collisionBlockOffsetCount = buf.readInt();
        for (int i = 0; i < collisionBlockOffsetCount; ++i) {
            this.collisionBlockOffsets.add(PacketTileEntityRoadCollisionUpdate.readPoint3dCompactFromBuffer(buf));
        }
        this.collidingBlockOffsets = new ArrayList<Point3D>();
        int collidingBlockOffsetCount = buf.readInt();
        for (int i = 0; i < collidingBlockOffsetCount; ++i) {
            this.collidingBlockOffsets.add(PacketTileEntityRoadCollisionUpdate.readPoint3dCompactFromBuffer(buf));
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.collisionBlockOffsets.size());
        for (Point3D point : this.collisionBlockOffsets) {
            PacketTileEntityRoadCollisionUpdate.writePoint3dCompactToBuffer(point, buf);
        }
        buf.writeInt(this.collidingBlockOffsets.size());
        for (Point3D point : this.collidingBlockOffsets) {
            PacketTileEntityRoadCollisionUpdate.writePoint3dCompactToBuffer(point, buf);
        }
    }

    @Override
    protected boolean handle(AWrapperWorld world, TileEntityRoad road) {
        road.collisionBlockOffsets.clear();
        road.collisionBlockOffsets.addAll(this.collisionBlockOffsets);
        road.collidingBlockOffsets.clear();
        road.collidingBlockOffsets.addAll(this.collidingBlockOffsets);
        road.blockingBoundingBoxes.clear();
        if (!road.isActive() && road.collidingBlockOffsets.isEmpty()) {
            road.setActive(true);
        }
        return false;
    }
}

